#include <iostream>
#include <set>
#include <unordered_map>
#include <vector>

using namespace std;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n, q, mode, x;
    cin >> n >> q;

    vector<int> a(n);
    unordered_map<int, long long> cards;
    set<pair<long long, int>> values;
    for (int i = 0; i < n; i++) {
        cin >> x;
        a[i] = x;
        auto &card = cards[x];
        auto old = values.find({card, x});
        card += x;

        if (old != values.end()) {
            auto node = values.extract(old);
            node.value().first = card;
            values.insert(std::move(node));
        } else {
            values.insert({card, x});
        }
    }

    for (int i = 0; i < q; i++) {
        cin >> mode >> x;
        if (mode == 1) {
            int j = 0, stop = values.size() - n + x;
            if (stop <= 0) {
                cout << 0 << '\n';
                continue;
            }

            long long sum = 0;
            for (auto &value : values) {
                if (j == stop) break;
                sum += value.first;
                j++;
            }

            cout << sum << '\n';
        } else {
            auto &y = a[x - 1];
            auto old = y;
            cin >> y;

            if (old == y) continue;
            auto &old_card = cards[old];
            auto it_old = values.find({old_card, old});
            old_card -= old;

            if (old_card == 0) {
                values.erase(it_old);
            } else {
                auto node = values.extract(it_old);
                node.value().first = old_card;
                values.insert(std::move(node));
            }

            auto &card = cards[y];
            auto it = values.find({card, y});
            card += y;
            if (it != values.end()) {
                auto node = values.extract(it);
                node.value().first = card;
                values.insert(std::move(node));
            } else {
                values.insert({card, y});
            }
        }
    }

    return 0;
}